<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoleMasterController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\UserMasterController;
use App\Http\Controllers\UsrDeptMapController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::prefix('roles')->group(function () {
    Route::get('/lst-role-master', [RoleMasterController::class, 'index']);
    Route::get('/all-role-master', [RoleMasterController::class, 'getAllRolesList']);
    Route::post('/', [RoleMasterController::class, 'store']);
    // Route::post('/bulk', [RoleMasterController::class, 'bulkStore']);
    Route::get('/{id}', [RoleMasterController::class, 'show']);
    Route::put('/{id}', [RoleMasterController::class, 'update']);
    Route::delete('/{id}', [RoleMasterController::class, 'destroy']);
});

Route::prefix('dpt-master')->group(function () {
    Route::get('/lst-dpt-master', [DepartmentController::class, 'index']);                    // Paginated list
    Route::get('/all/lst-dpt-master', [DepartmentController::class, 'getAllDepartments']); // All data without pagination
    Route::post('/', [DepartmentController::class, 'store']);
    Route::get('/active', [DepartmentController::class, 'activeDepartments']);
    Route::get('/{id}', [DepartmentController::class, 'show']);
    Route::put('/{id}', [DepartmentController::class, 'update']);
    Route::delete('/{id}', [DepartmentController::class, 'destroy']);
    Route::get('/building/{building}', [DepartmentController::class, 'getByBuilding']);
    Route::get('/{id}/statistics', [DepartmentController::class, 'getStatistics']);
    Route::post('/check-ip', [DepartmentController::class, 'checkIP']);
    Route::get('/{id}/users', [DepartmentController::class, 'getUsers']);
});

Route::get('profile', [UserMasterController::class, 'profile']);
Route::put('profile', [UserMasterController::class, 'updateProfile']);

// User Management
Route::apiResource('usr-master', UserMasterController::class);
Route::get('/lst-usr-master', [UserMasterController::class, 'getAllUsers']);
Route::post('/{id}/restore', [UserMasterController::class, 'restore']);
Route::post('/{id}/toggle-mfa', [UserMasterController::class, 'toggleMfa']);
Route::post('/{id}/toggle-lock', [UserMasterController::class, 'toggleLock']);
Route::post('/{id}/reset-password', [UserMasterController::class, 'resetPassword']);
Route::get('/{id}/sessions', [UserMasterController::class, 'getUserSessions']);
Route::get('/{id}/audit-logs', [UserMasterController::class, 'getUserAuditLogs']);



Route::get('/Lst-UsrDpt-Map', [UsrDeptMapController::class, 'index']);
Route::post('/UsrDpt-Map', [UsrDeptMapController::class, 'store']);
Route::get('/Lst-UsrDpt-Map/{id}', [UsrDeptMapController::class, 'show']);
Route::put('/UsrDpt-Map/{id}', [UsrDeptMapController::class, 'update']);
Route::delete('/UsrDpt-Map/{id}', [UsrDeptMapController::class, 'destroy']);
