<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_master', function (Blueprint $table) {
            $table->bigIncrements('Usr_Id');
            $table->string('Usr_Name', 50)->unique();
            $table->string('Usr_Pas', 255);
            $table->unsignedBigInteger('Usr_Role_Id')->nullable();
            $table->unsignedBigInteger('Usr_Dpt_Id')->nullable();
            $table->string('Usr_Email', 100)->nullable()->unique();
            $table->string('Usr_Mobile', 15)->nullable()->unique();
            $table->tinyInteger('is_active')->default(1);
            $table->tinyInteger('is_locked')->default(0);
            $table->text('locked_reason')->nullable();
            $table->timestamp('locked_until')->nullable();
            $table->integer('failed_login_attempts')->default(0);
            $table->timestamp('last_login')->nullable();
            $table->timestamp('last_password_change')->nullable();
            $table->tinyInteger('mfa_enabled')->default(0);
            $table->string('mfa_secret', 100)->nullable();
            $table->integer('session_timeout')->default(30);
            $table->integer('password_expiry_days')->default(90);
            $table->timestamps(); // created_at and updated_at
            $table->softDeletes(); // deleted_at

           
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_master');
    }
};
