<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('role_master', function (Blueprint $table) {
            $table->id('Role_Id'); // bigint unsigned AUTO_INCREMENT primary key
            $table->string('Role_Prefix', 5)->nullable();
            $table->string('Role_Name');
            $table->char('TwoFacAuth', 1)->nullable()->comment('Y=Yes, N=No');
            $table->boolean('Is_Active')->default(1);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable(); // soft deletes if needed
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_master');
    }
};
