<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'dept_master';

    // Primary key
    protected $primaryKey = 'Dpt_id';

    // Auto-incrementing
    public $incrementing = true;

    // Key type
    protected $keyType = 'int';

    // ✅ Fillable fields (ONLY changed here)
    protected $fillable = [
        'Dpt_Desc',
        'Dpt_Name',
        'GrCod',
        'UpGrp',
        'GrSrn',
        'GrStt',
        'isvisible'
    ];

    // Casts
    protected $casts = [
        'Dpt_id' => 'integer'
    ];

    // Timestamps
    public $timestamps = true;

    // ❌ NOTHING changed below
    public function grantMappings()
    {
        return $this->hasMany(GrantDivisionMapping::class, 'dept_id', 'Dpt_id');
    }

    public function scopeByType($query, $type)
    {
        return $query->where('GrStt', $type);
    }

    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    public function scopeAllData($query)
    {
        return $query->orderBy('Dpt_id', 'asc');
    }
}
