<?php

namespace App\Http\Controllers;

use App\Models\UsrDptMap;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class UsrDeptMapController extends Controller
{
    // LIST WITH USER + DEPARTMENT
public function index()
{
    $data = UsrDptMap::with(['user', 'department'])->get();

    if ($data->isNotEmpty()) {
        $first = $data->first();

    }

    return response()->json([
        'status' => true,
        'data'   => $data
    ]);
}

    // CREATE
public function store(Request $request)
{
    $validator = Validator::make($request->all(), [
        'Usr_Id' => 'required|integer|exists:user_master,Usr_Id',
        'Dpt_Id' => 'required|integer|exists:dept_master,Dpt_id',
        'Status' => 'nullable|boolean'
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status' => false,
            'errors' => $validator->errors()
        ], 422);
    }

    $data = UsrDptMap::create([
        'Usr_Id' => $request->Usr_Id,
        'Dpt_Id' => $request->Dpt_Id,
        'Status' => $request->Status ?? 1
    ]);

    return response()->json([
        'status' => true,
        'message' => 'Mapping created',
        'data' => UsrDptMap::with(['user','department'])
                    ->find($data->UDM_Id)
    ]);
}


    // VIEW SINGLE WITH RELATIONS
    public function show($id)
    {
        $data = UsrDptMap::with(['user','department'])->find($id);

        if (!$data) {
            return response()->json([
                'status'=>false,
                'message'=>'Not found'
            ],404);
        }

        return response()->json([
            'status'=>true,
            'data'=>$data
        ]);
    }

    // UPDATE
public function update(Request $request, $id)
{
    $data = UsrDptMap::find($id);

    if (!$data) {
        return response()->json([
            'status'=>false,
            'message'=>'Not found'
        ],404);
    }

    $validator = Validator::make($request->all(), [
        'Usr_Id' => 'required|integer|exists:user_master,Usr_Id',
        'Dpt_Id' => 'required|integer|exists:dept_master,Dpt_id',
        'Status' => 'nullable|boolean'
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status'=>false,
            'errors'=>$validator->errors()
        ],422);
    }

    $data->update($request->only([
        'Usr_Id',
        'Dpt_Id',
        'Status'
    ]));

    return response()->json([
        'status'=>true,
        'message'=>'Updated successfully',
        'data'=> UsrDptMap::with(['user','department'])
                    ->find($id)
    ]);
}


    // DELETE
    public function destroy($id)
    {
        $data = UsrDptMap::find($id);

        if (!$data) {
            return response()->json([
                'status'=>false,
                'message'=>'Not found'
            ],404);
        }

        $data->delete();

        return response()->json([
            'status'=>true,
            'message'=>'Deleted successfully'
        ]);
    }
}
